qui {

noi {
	/*************************************************/
	/***** Step 2.4.2. Full sample estimation	    **/
	/*************************************************/
}

	* STEP 1. Compute NIC-specific independence dividends and RMSPE for each robustness check
	noi di ""
	noi di "Compute independence dividend estimates using different weighting schemes"
	noi di ""
	noi di ""
	
		* Weighting scheme 1
		noi di "Unweighted: bootstrap iteration (/${firststepreps}):", _continue
		local j = 0
		cd ..

		* Get data
		cd ".\3. Intermediary results\3.4. Intermediaries"
		use total_file, clear
		cd ..
		cd ..
	
		* Compute aggregate independence dividend
		preserve
		collapse (mean) bc_lgap if cntrycode < 400, by(independence_years)
		gen iteration = 0	
		tempfile bs
		save `bs', emptyok
		restore

		* Bootstrap placebo-estimates
		cd ".\3. Intermediary results\3.4. Intermediaries"
		foreach iteration of numlist 1/$firststepreps {
			noi di `iteration', _continue
			preserve
			gen cntrycode_NIC = cntrycode if cntrycode < 400
			replace cntrycode_NIC = round(cntrycode/1000) if cntrycode > 400
			bsample 1 if cntrycode > 400, cluster(cntrycode) strata(cntrycode_NIC)
			collapse (mean) bc_lgap, by(independence_years)
			gen iteration = `iteration'
			append using `bs', force
			save `bs', replace
			restore
			}
		
		* Get actual and bootstrapped placebo results
		use `bs', clear
		sort iteration independence_years
		cd ..
		cd ..
		
		* Compute aggregate CI's
		gen PTDIDD = .
		gen PTDIDD_ll = .
		gen PTDIDD_ul = .

		foreach year of numlist -10/30 {
			sum bc_lgap if independence_years == `year' & iteration != 0
			cap replace PTDIDD = bc_lgap-`r(mean)' if independence_years == `year' & iteration == 0
			cap replace PTDIDD_ll = PTDIDD+invttail((`r(N)'-1),.975)*`r(sd)' if independence_years == `year' & iteration == 0
			cap replace PTDIDD_ul = PTDIDD+invttail((`r(N)'-1),.025)*`r(sd)' if independence_years == `year' & iteration == 0
			}
			
		* Save results
		preserve
		keep if iteration == 0
		sort iteration independence_years
		drop iteration
		drop if PTDIDD == .
		cd ".\3. Intermediary results"
		save w1_results, replace
		cd ..
		restore	
		
		* Weighting scheme 2
		noi di ""
		noi di ""
		noi di "RMSPE-weighted: bootstrap iteration (/${firststepreps}):", _continue
		local j = 0
		
		* Get data
		cd ".\3. Intermediary results\3.4. Intermediaries"
		use total_file, clear
		cd ..
		cd ..
		
		* Compute inverse RMSPE
		gen w_rmspe = 1/rmspe
	
		* Compute aggregate independence dividend
		preserve
		collapse (mean) bc_lgap if cntrycode < 400 [w=w_rmspe], by(independence_years)
		gen iteration = 0	
		tempfile bs
		save `bs', emptyok
		restore

		* Bootstrap placebo-estimates
		cd ".\3. Intermediary results\3.4. Intermediaries"
		foreach iteration of numlist 1/$firststepreps {
			noi di `iteration', _continue
			preserve
			gen cntrycode_NIC = cntrycode if cntrycode < 400
			replace cntrycode_NIC = round(cntrycode/1000) if cntrycode > 400
			bsample 1 if cntrycode > 400, cluster(cntrycode) strata(cntrycode_NIC)
			collapse (mean) bc_lgap [w=w_rmspe], by(independence_years)
			gen iteration = `iteration'
			append using `bs', force
			save `bs', replace
			restore
			}
		
		* Get actual and bootstrapped placebo results
		use `bs', clear
		sort iteration independence_years
		cd ..
		cd ..
		
		* Compute aggregate CI's
		gen PTDIDD = .
		gen PTDIDD_ll = .
		gen PTDIDD_ul = .

		foreach year of numlist -10/30 {
			sum bc_lgap if independence_years == `year' & iteration != 0
			cap replace PTDIDD = bc_lgap-`r(mean)' if independence_years == `year' & iteration == 0
			cap replace PTDIDD_ll = PTDIDD+invttail((`r(N)'-1),.975)*`r(sd)' if independence_years == `year' & iteration == 0
			cap replace PTDIDD_ul = PTDIDD+invttail((`r(N)'-1),.025)*`r(sd)' if independence_years == `year' & iteration == 0
			}
			
		* Save results
		preserve
		keep if iteration == 0
		sort iteration independence_years
		drop iteration
		drop if PTDIDD == .
		cd ".\3. Intermediary results"
		save w2_results, replace
		cd ..
		restore

	* Gather & plot results
	
		* Gather data
		cd ".\3. Intermediary results"
		use baseline_results, clear
		gen case = 1
		append using w1_results
		replace case = 2 if case == .
		append using w2_results
		replace case = 3 if case == .

		cd ..
		
		* Plot robustness check results		
		preserve
		drop if independence_years < -10 | independence_years > 30
		
		twoway 	rline PTDIDD_ll PTDIDD_ul independence_years if case == 3, lstyle(ci) lcolor(gs11) lpattern("__")|| 	///
				connected PTDIDD independence_years if case == 3,  mlcolor(gs11) mfcolor(gs11) lcolor(gs11) lpattern(dot) msymbol(T) 	||				///
				rline PTDIDD_ll PTDIDD_ul independence_years if case == 2, lstyle(ci) lcolor(gs8) lpattern("--") || 	///
				connected PTDIDD independence_years if case == 2,  mlcolor(gs8) mfcolor(gs8) lcolor(gs8) lpattern("--") msymbol(O) 	||				///
				rline PTDIDD_ll PTDIDD_ul independence_years if case == 1, lstyle(ci) lcolor(gs0)  || 	///
				connected PTDIDD independence_years if case == 1,  mlcolor(gs0) mfcolor(gs0) lcolor(gs0) lpattern("__") msymbol(D) msize(medsmall)					///
				yline(0, lpattern(solid) lcolor(gs13)) xline(0, lcolor(red) lp(dot)) ///
				legend(order(6 "Baseline" 4 "Equal weights" 2 "Inverse RMSPE weights") rows(2)) ytitle("Independence dividend") xtitle("Years of independence", size(large)) title("") graphregion(color(white)) bgcolor(white) 	///
				note("with 95% confidence intervals")          ///
				name(rline, replace)	
		cd ".\5. TeX results"
		graph export figureA7.pdf, replace
		cd ..
		restore

	* Reroute to directory containing dofiles
	cd ".\1. Dofiles"
	}
